<?php
// Fix orders table structure
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "reviewprcom_db";

try {
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    
    echo "<h2>Fixing Orders Table Structure...</h2>";
    
    // Check if orders table exists and show its structure
    $check_table = $conn->query("SHOW TABLES LIKE 'orders'");
    if ($check_table->num_rows > 0) {
        echo "<p>📋 Orders table exists, checking structure...</p>";
        
        // Show current structure
        $structure = $conn->query("DESCRIBE orders");
        echo "<p>Current columns:</p><ul>";
        while ($row = $structure->fetch_assoc()) {
            echo "<li>{$row['Field']} - {$row['Type']}</li>";
        }
        echo "</ul>";
        
        // Drop the table
        $conn->query("DROP TABLE orders");
        echo "<p>✅ Dropped existing orders table</p>";
    }
    
    // Create orders table with correct structure
    $create_table = "CREATE TABLE IF NOT EXISTS orders (
        id INT AUTO_INCREMENT PRIMARY KEY,
        order_id VARCHAR(20) NOT NULL,
        product_id INT,
        product_name VARCHAR(255) NOT NULL,
        price DECIMAL(10,2) NOT NULL,
        quantity INT DEFAULT 1,
        total DECIMAL(10,2) NOT NULL,
        customer_email VARCHAR(100) NOT NULL,
        review_location TEXT,
        promo_code VARCHAR(50),
        reviews_per_day INT,
        file_name VARCHAR(255),
        file_link TEXT,
        customer_notes TEXT,
        status ENUM('pending','processing','completed','cancelled') DEFAULT 'pending',
        order_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        INDEX idx_order_id (order_id),
        INDEX idx_customer_email (customer_email),
        INDEX idx_status (status)
    )";
    
    if ($conn->query($create_table)) {
        echo "<p>✅ Created new orders table with correct structure</p>";
        
        // Insert a sample order for testing
        $orderId = 'ORD-' . strtoupper(substr(md5(uniqid()), 0, 8));
        
        $sql = "INSERT INTO orders (order_id, product_id, product_name, price, quantity, total, customer_email, review_location, promo_code, reviews_per_day, file_name, file_link, customer_notes, status, order_date)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'pending', NOW())";
        
        $stmt = $conn->prepare($sql);
        
        if ($stmt) {
            $product_id = 1;
            $product_name = "Google Reviews Package";
            $price = 49.99;
            $quantity = 1;
            $total = 49.99;
            $customer_email = "john.doe@example.com";
            $review_location = "Google My Business";
            $promo_code = "";
            $reviews_per_day = 2;
            $file_name = "";
            $file_link = "";
            $customer_notes = "Sample order for testing admin panel integration";
            
            $stmt->bind_param(
                "sisddssssisss",
                $orderId,
                $product_id,
                $product_name,
                $price,
                $quantity,
                $total,
                $customer_email,
                $review_location,
                $promo_code,
                $reviews_per_day,
                $file_name,
                $file_link,
                $customer_notes
            );
            
            if ($stmt->execute()) {
                echo "<p>✅ Created sample order: $orderId</p>";
                
                // Create another sample order
                $orderId2 = 'ORD-' . strtoupper(substr(md5(uniqid() . '2'), 0, 8));
                $stmt->bind_param(
                    "sisddssssisss",
                    $orderId2,
                    2,
                    "Facebook Reviews Boost",
                    39.99,
                    1,
                    39.99,
                    "jane.smith@example.com",
                    "Facebook Business Page",
                    "SAVE10",
                    3,
                    "",
                    "",
                    "Need reviews for new restaurant"
                );
                
                if ($stmt->execute()) {
                    echo "<p>✅ Created second sample order: $orderId2</p>";
                }
            }
            
            $stmt->close();
        }
        
        echo "<br><h3>✅ Orders Table Fixed Successfully!</h3>";
        echo "<p>The orders table now has the correct structure and sample data.</p>";
        echo "<br>";
        echo "<a href='admin_dashboard.php' style='background: #3b82f6; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-right: 10px;'>View Admin Panel</a>";
        echo "<a href='test_order.php' style='background: #10b981; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-right: 10px;'>Test Order Creation</a>";
        echo "<a href='index.php' style='background: #6b7280; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Back to Website</a>";
        
    } else {
        echo "<p>❌ Error creating orders table: " . $conn->error . "</p>";
    }
    
    $conn->close();
    
} catch (Exception $e) {
    echo "<h2>❌ Connection Error</h2>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
}
?>

<style>
body { font-family: Arial, sans-serif; max-width: 800px; margin: 50px auto; padding: 20px; }
h2, h3 { color: #333; }
p { margin: 10px 0; }
</style>
